/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.utils;

import filenet.vw.base.VWAuthItem;
import filenet.vw.base.VWConvertTwo;
import filenet.vw.base.logging.Logger;

public class WSEncString {
    private static final String ENC_BEGIN = "!$FNENC_BEG$!";
    private static final String ENC_END = "!$FNENC_END$!";
    protected static Logger logger = Logger.getLogger("filenet.ws.utils");
    private static final String m_className = "WSEncString";
    private static final int KEY_MASK = 0;
    public String m_resString = null;

    public String toString() {
        return this.m_resString;
    }

    public WSEncString(String s, String matchToken) {
        this.m_resString = s;
        if (!(s.startsWith("0") || s.startsWith("1") || s.startsWith("a") || s.startsWith("A") || s.startsWith("#") || s.startsWith("$"))) {
            return;
        }
        String m_name = null;
        String m_pw = null;
        s = s.substring(1);
        try {
            VWCMConvertTwo converter = new VWCMConvertTwo(0);
            VWAuthItem item = converter.getDString(s);
            if (item != null) {
                m_name = item.getName();
                m_pw = item.getPassword();
                if (m_pw != null && m_pw.compareTo("\"\"") == 0) {
                    m_pw = "";
                }
            }
            if (!m_pw.equals(matchToken)) {
                return;
            }
            this.m_resString = m_name;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static String Decode(String s, String matchToken) {
        String m_method = "Decode";
        int begIndex = s.indexOf(ENC_BEGIN);
        if (begIndex == -1) {
            return s;
        }
        int endIndex = s.indexOf(ENC_END, begIndex);
        if (endIndex == -1) {
            return s;
        }
        if (logger.isFinest()) {
            logger.finest(m_className, "Decode", "tok=" + matchToken + ", s=" + s);
        }
        StringBuffer buf = new StringBuffer();
        while (begIndex != -1 && endIndex != -1) {
            buf.append(s.substring(0, begIndex));
            String newString = s.substring(begIndex + ENC_BEGIN.length(), endIndex);
            WSEncString encString = new WSEncString(newString, matchToken);
            buf.append(encString.toString());
            begIndex = (s = s.substring(endIndex + ENC_END.length())).indexOf(ENC_BEGIN);
            if (begIndex == -1) continue;
            endIndex = s.indexOf(ENC_END, begIndex);
        }
        buf.append(s);
        String res = buf.toString();
        if (logger.isFinest()) {
            logger.finest(m_className, "Decode", "res=" + res);
        }
        return res;
    }

    public static void main(String[] args) {
        try {
            String s = "[!$FNENC_BEG$!#mhaM+OeKch0Mah4xePeMfhncaOiOh4b9aOmLa3iOb495byj5bOaNeOb3c3mQfy8Fah8Pbxe=!$FNENC_END$!]==TOTHISVALUE==[!$FNENC_BEG$!#mhaM+OeKch0Mah4xePeMfhncaOiOh4b9aOmLa3iOb495byj5bOaNeOb3c3mQfy8Fah8Pbxe=!$FNENC_END$!]";
            String match = "D921C2634C310544BE6EE7C3CCC866FB";
            String s1 = WSEncString.Decode(s, match);
            System.out.println(s1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    final class VWCMConvertTwo
    extends VWConvertTwo {
        int KEY_MASK = 0;

        protected VWCMConvertTwo(int mask) {
            this.KEY_MASK = mask;
        }

        protected String getKey(int id) {
            return "MIIBCTCBtAIBADBPMQswCQYDeQQGEwJV6s4fUzEQMA4GA1UECBMHRmxvcmlkYTEYMBYGA1UEChMPRXllcyBvbiBUaGUgV2ViMRQwEgYDVQQDFAt3d3cuZXR3Lm5ldDBcMA0GCSqGSIb3DQEBAQUAA0sAMEgCQQCeojtjnHqg0GTxp+XZ56RaSe1iZWpumXjU6Sx7v1FdXzsY1oLOQa090Jtnu1WsQRHh0yDS+45oncjKm1zCIZAgMBAAGgADANBgkqhkiG9w0BAQQFAANBAFBj9g+NiUh8YWPrFGntgf4miUdwqUshptjJy4PjdsD*3ugy5avvuh3GPpGh2aYXIjHpJXTUBQyzxSEIINYtc";
        }

        protected String getEString(String name, String password) throws Exception {
            return super.getEString(name, password);
        }

        protected VWAuthItem getDString(String token) throws Exception {
            return super.getDString(token);
        }
    }
}

